package cn.com.duiba.live.statistics.service.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.user.LiveUserScoreStatDto;

import java.util.List;
import java.util.Set;

/**
 * @author 吴文哲
 * @date 2021/1/4 5:39 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveUserScoreStatApiService {

    /**
     * 批量插入
     * @param liveUserScoreStatEntities
     * @return
     */
    int batchInsert(List<LiveUserScoreStatDto> liveUserScoreStatEntities);

    /**
     * 查询
     * @param liveId
     * @param visitorIds
     * @return
     */
    Set<Long> selectByLiveAndVisitorIds( Long liveId, List<Long> visitorIds);

    /**
     * 批量跟新
     * @param updateList
     * @return
     */
    int batchUpdate(List<LiveUserScoreStatDto> updateList);
}
