/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.statistics.service.api.enums.customer;

import cn.com.duiba.live.statistics.service.api.enums.customer.AgeEnum;
import cn.com.duiba.live.statistics.service.api.enums.customer.HasInsuranceEnum;
import cn.com.duiba.live.statistics.service.api.enums.customer.IncomeEnum;
import cn.com.duiba.live.statistics.service.api.enums.customer.InsuranceAwarenessEnum;
import cn.com.duiba.live.statistics.service.api.enums.customer.SexEnum;
import cn.com.duiba.live.statistics.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AgentCustomerExtEnum {
    SEX(1, "\u6027\u522b"),
    AGE(2, "\u5e74\u9f84"),
    JOB(3, "\u804c\u4e1a"),
    INCOME(4, "\u6536\u5165"),
    LOCATION(5, "\u5730\u5740"),
    HOBBY(6, "\u7231\u597d"),
    INSURANCE_AWARENESS(7, "\u4fdd\u9669\u610f\u8bc6"),
    HAS_INSURANCE(8, "\u6301\u4fdd\u60c5\u51b5"),
    MARRIAGE_STATUS(9, "\u5a5a\u59fb\u72b6\u51b5"),
    HAS_CHILDREN(10, "\u662f\u5426\u6709\u5b50\u5973"),
    FAMILY_MEMBER(11, "\u5bb6\u5ead\u6210\u5458\u4eba\u6570"),
    FAMILY_INCOME(12, "\u5bb6\u5ead\u5e74\u6536\u5165");

    private static final Logger log;
    private final Integer infoName;
    private final String desc;
    private static final Map<Integer, AgentCustomerExtEnum> ENUM_MAP;
    private static final List<Integer> INFO_NAME_LIST;
    private static final List<Integer> NON_ENUM_TYPE_VALUE;

    public static boolean existEnum(Integer infoName) {
        if (NumberUtil.isNullOrLteZero(infoName)) {
            return false;
        }
        AgentCustomerExtEnum item = ENUM_MAP.get(infoName);
        return Objects.nonNull((Object)item);
    }

    public static List<Integer> getInfoNameList() {
        return Collections.unmodifiableList(INFO_NAME_LIST);
    }

    public static boolean checkExtValue(Integer infoName, String infoValue) {
        boolean flag;
        int value;
        AgentCustomerExtEnum enumType = ENUM_MAP.get(infoName);
        if (Objects.isNull((Object)enumType)) {
            log.warn("info name is illegal, not exist this enum type, infoName={}, infoValue={}", (Object)infoName, (Object)infoValue);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)infoValue)) {
            return true;
        }
        if (NON_ENUM_TYPE_VALUE.contains(infoName)) {
            return true;
        }
        try {
            value = Integer.parseInt(infoValue);
        }
        catch (Exception e) {
            log.warn("infoValue is illegal, infoValue should be int, infoValue={}", (Object)infoValue);
            return false;
        }
        switch (enumType) {
            case SEX: {
                flag = SexEnum.existEnum(value);
                break;
            }
            case AGE: {
                flag = AgeEnum.existEnum(value);
                break;
            }
            case INCOME: {
                flag = IncomeEnum.existEnum(value);
                break;
            }
            case INSURANCE_AWARENESS: {
                flag = InsuranceAwarenessEnum.existEnum(value);
                break;
            }
            case HAS_INSURANCE: {
                flag = HasInsuranceEnum.existEnum(value);
                break;
            }
            default: {
                flag = false;
            }
        }
        return flag;
    }

    public Integer getInfoName() {
        return this.infoName;
    }

    public String getDesc() {
        return this.desc;
    }

    private AgentCustomerExtEnum(Integer infoName, String desc) {
        this.infoName = infoName;
        this.desc = desc;
    }

    static {
        log = LoggerFactory.getLogger(AgentCustomerExtEnum.class);
        ENUM_MAP = Maps.newHashMap();
        INFO_NAME_LIST = Lists.newArrayList();
        NON_ENUM_TYPE_VALUE = Lists.newArrayList();
        for (AgentCustomerExtEnum item : AgentCustomerExtEnum.values()) {
            ENUM_MAP.put(item.getInfoName(), item);
            INFO_NAME_LIST.add(item.infoName);
        }
        NON_ENUM_TYPE_VALUE.add(AgentCustomerExtEnum.JOB.infoName);
        NON_ENUM_TYPE_VALUE.add(AgentCustomerExtEnum.LOCATION.infoName);
        NON_ENUM_TYPE_VALUE.add(AgentCustomerExtEnum.HOBBY.infoName);
    }
}

