package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户持保情况枚举
 *
 * @author ZhangJun
 * @date 2021/7/2 4:56 下午
 */
@Getter
@AllArgsConstructor
public enum HasInsuranceEnum {

    /**
     * 未知
     */
    UN_KNOW(null, "未知"),

    /**
     * 未持保
     */
    HAS_NOT_INSURANCE(0, "未持保"),

    /**
     * 已持保
     */
    HAS_INSURANCE(1, "已持保");


    /**
     * 是否持保
     */
    private final Integer hasInsurance;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, HasInsuranceEnum> ENUM_MAP = new HashMap<>();

    static {
        for (HasInsuranceEnum item : values()) {
            ENUM_MAP.put(item.getHasInsurance(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer hasInsurance) {
        return Objects.nonNull(ENUM_MAP.get(hasInsurance));
    }

}
