package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户性别枚举
 *
 * @author ZhangJun
 * @date 2021/7/2 5:06 下午
 */
@Getter
@AllArgsConstructor
public enum SexEnum {

    /**
     * 未知
     */
    UN_KNOW_NULL(null, "未知"),

    /**
     * 未知
     */
    UN_KNOW_ZERO(0, "未知"),

    /**
     * 男
     */
    MAN(1, "男"),

    /**
     * 女
     */
    WOMAN(2, "女"),
    ;


    /**
     * 性别
     */
    private final Integer sex;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, SexEnum> ENUM_MAP = new HashMap<>();

    static {
        for (SexEnum item : values()) {
            ENUM_MAP.put(item.getSex(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer sex) {
        return Objects.nonNull(ENUM_MAP.get(sex));
    }
}
