package cn.com.duiba.live.statistics.service.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.red.RedPacketStatDto;

import java.util.List;

/**
 * 红包统计rpc接口
 *
 * @author 吴文哲
 * @date 2021/9/8 3:56 下午
 **/
@AdvancedFeignClient
public interface RemoteRedPacketStatApiService {

    /**
     * 新增红包统计信息
     *
     * @param dto 红包统计
     * @return 影响行数
     */
    int addRedPacketStat(RedPacketStatDto dto);

    /**
     * 增加红包库存
     *
     * @param redConfId 红包配置id
     * @param redNum    红包数量
     * @param redMoney  红包金额
     * @return 影响行数
     */
    int increaseRedStock(Long redConfId, int redNum, int redMoney);

    /**
     * 扣减红包库存
     *
     * @param redConfId 红包配置id
     * @param redNum    红包数量
     * @param redMoney  红包金额
     * @return 影响行数
     */
    int decreaseRedStock(Long redConfId, int redNum, int redMoney);


    /**
     * 根据直播间id 查询红包统计列表
     *
     * @param liveId 直播间id
     * @return 红包统计信息列表
     */
    List<RedPacketStatDto> selectByLiveId(Long liveId);

    /**
     * 根据红包配置id查询红包统计信息
     *
     * @param redConfId 红包配置id
     * @return 红包统计信息
     */
    RedPacketStatDto selectByRedConfId(Long redConfId);
}
