package cn.com.duiba.live.statistics.service.api.remoteservice.sessionwatch;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.sessionwatch.LiveSessionWatchDto;
import cn.com.duiba.live.statistics.service.api.param.sessionwatch.LiveSessionWatchSearchParam;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2021/1/4 11:42 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveSessionWatchApiService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return ws服务监控数据集合
     */
    List<LiveSessionWatchDto> selectList(LiveSessionWatchSearchParam param);

    /**
     * 新增
     * @param entity ws服务监控数据
     * @return 执行结果
     */
    int insert(LiveSessionWatchDto entity);

    /**
     * 插入条数
     * @return
     */
    int batchInsert(List<LiveSessionWatchDto> list);
}
