package cn.com.duiba.live.statistics.service.api.remoteservice.team;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.team.LiveStatisticsTeamDto;
import cn.com.duiba.live.statistics.service.api.dto.team.TeamPresentStaticsBean;
import cn.com.duiba.live.statistics.service.api.dto.team.TeamStaticsBean;
import cn.com.duiba.live.statistics.service.api.param.team.LiveStatisticsTeamSearchParam;

import java.util.List;
import java.util.Set;

/**
 * @author 吴文哲
 * @date 2021/1/4 4:47 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsTeamApiService {

    /**
     * 根据直播间id 团队id 获取统计数据
     * @param liveId
     * @param teamId
     * @return
     */
    LiveStatisticsTeamDto getByLiveIdAndTeamId(Long liveId, Long teamId);

    /**
     * 根据条件获取对应直播间 团队纬度统计数据
     * @param param
     * @return
     */
    List<LiveStatisticsTeamDto> getListByCondition(LiveStatisticsTeamSearchParam param);

    /**
     * 新增某次直播某个团队的邀请数量
     * @param liveId 直播ID
     * @param teamId 团队id
     * @return 新增数量> 0 新增成功
     */
    int atomicIncreaseInvitationNum(Long liveId, Long teamId);

    /**
     * 新增
     * @param dto 直播统计-团队维度统计信息
     * @return 执行结果
     */
    int insert(LiveStatisticsTeamDto dto);

    /**
     * 新增某次直播某个团队的到场人数
     * @param liveId 直播ID
     * @param teamId 代理人公司团队id
     * @return 新增数量> 0 新增成功
     */
    int atomicIncreasePresentNum(Long liveId, Long teamId);


    /**
     * 根据直播IDs 和 团队ID  意义：排除掉已经存在的统计记录
     * @param teamId 团队ID
     * @param liveIds 直播IDs
     * @return 已经存在的直播IDs
     */
    List<Long> selectLiveIdsByTeamIdAndLiveIds( Long teamId, List<Long> liveIds);

    /**
     * 获取团队当前排名
     * @param liveId 直播间id
     * @param teamId 团队id
     * @return
     */
    Integer getTeamRanking(Long liveId, Long teamId);


    /**
     * 批量初始化一个团队多个直播的统计数据
     * @param teamId 团队id
     * @param companyId 公司id
     * @param liveIds 直播
     * @return
     */
    int batchInsertOneTeamMoreLives(Long teamId ,Long companyId, List<Long> liveIds);

    /**
     * 根据直播ID 和 团队IDs 意义：排除掉已经存在的统计记录
     * @param liveId 直播ID
     * @param teamIds 团队ids
     * @return 已经存在直播IDs
     */
    List<Long> selectTeamIdsByIdAndTeamIds( Long liveId, Set<Long> teamIds);


    /**
     * 批量跟新邀请人数和在线人数
     * @param agentStaticsBeanList
     * @param liveId
     * @return 影响行数
     * 使用队列批量修改,不要依赖返回值处理其它逻辑
     */
    int batchUpdate(List<TeamStaticsBean> agentStaticsBeanList,  Long liveId);


    /**
     * 删除团队下的未开播的统计数据
     * @param teamId   团队ID
     * @param liveIds 直播IDs
     * @return
     */
    int deleteByTeamId(Long teamId, List<Long> liveIds);

    /**
     * 直播结束 计算团队排名
     * @param liveId
     * @return
     */
    Integer statisticTeamRank(Long liveId);


    /**
     * 全量更新在线数
     */
    int batchUpdatePresentNum(Long liveId, List<TeamPresentStaticsBean> teamPresentBeans);

}
