package cn.com.duiba.live.statistics.service.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.user.LiveStatisticsVisitorDto;

import java.util.List;

/**
 * 直播访客邀请数统计
 * @author 吴文哲
 * @date 2021/3/10 4:59 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsVisitorApiService {

    /**
     * 查询访客邀请数量统计
     * @param liveId 直播间id
     * @param agentId 代理人id
     * @param userIds 访客id列表
     * @return 邀请统计列表
     */
    List<LiveStatisticsVisitorDto> listByLiveIdAgentIdAndUserIds(Long liveId, Long agentId, List<Long> userIds);

    /**
     * 查询访客邀请统计记录
     * @param liveId 直播间id
     * @param userId 访客id
     * @return 直播用户访客邀请统计信息
     */
    LiveStatisticsVisitorDto findByLiveIdAndUserId(Long liveId,Long userId);

    /**
     * 插入一条
     * @param dto 直播用户邀请统计信息
     * @return 影响行数
     */
    int insert(LiveStatisticsVisitorDto dto);

    /**
     * 批量更新邀请统计数据
     * @param list 直播用户邀请统计列表
     * @return 影响行数
     */
    int batchUpdate(List<LiveStatisticsVisitorDto> list);

    /**
     * 根据直播间id + 访客id 查询访客邀请统计表数据
     * @param liveId 直播间id
     * @param liveUserIds 访客用户id
     * @return 直播访客邀请记录列表
     */
    List<LiveStatisticsVisitorDto> listByLiveIdAndUserIds(Long liveId, List<Long> liveUserIds);
}
