package cn.com.duiba.live.statistics.service.api.util;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;

/**
 * @author zhanghuifeng
 * date 2020/7/6-1:47 下午
 */
@Getter
@Setter
@Slf4j
public final class AesEncrypt implements Encryptor {

    private static final String AES_KEY = "aes.key.value";

    private Properties properties = new Properties();

    @Override
    public void init() {

    }

    @Override
    public String encrypt(Object plaintext) {
        if (null == plaintext) {
            return null;
        }
        return aesEncrypt(String.valueOf(plaintext));
    }

    private String aesEncrypt(String plaintext) {
        if (StringUtils.isBlank(plaintext)){
            return plaintext;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, getSecretKey());

            byte[] clearText = plaintext.getBytes(StandardCharsets.UTF_8);
            byte[] cipherTextBytes = cipher.doFinal(clearText);

            return Base64.getEncoder().encodeToString(cipherTextBytes);
        } catch (Exception e) {
            log.warn("",e);
        }
        return null;

    }

    @Override
    public Object decrypt(String cipherText) {
        return aesDecrypt(cipherText);
    }

    /**
     * AES 解密操作
     *
     * @param content
     * @return
     */
    private String aesDecrypt(String content) {
        if (StringUtils.isBlank(content)){
            return content;
        }
        try {
            //实例化
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, getSecretKey());
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(content));
            return new String(original, StandardCharsets.UTF_8);
        } catch (Exception ex) {
            log.error("",ex);
        }
        return content;
    }

    /**
     * 生成加密秘钥
     *
     * @return
     */
    private SecretKey getSecretKey() throws Exception {
        try {  //返回生成指定算法密钥生成器的 KeyGenerator 对象
            byte[] keyBytes = Arrays.copyOf(properties.get(AES_KEY).toString().getBytes(StandardCharsets.UTF_8), 16);
            return new SecretKeySpec(keyBytes, "AES");
        } catch (Exception ex) {
            log.error("加密秘钥失败" ,ex);
            throw new Exception("加密秘钥失败");
        }
    }


    @Override
    public String getType() {
        return "CustomAes";
    }

}
