package cn.com.duiba.live.ws.register.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * web socket 消息类型
 * @author lizhi
 * @date 2020/3/24 7:17 PM
 */
public enum WsMsgTypeEnum {

    //web socket 返回的对象，如果需要加密ID，请使用@JSONField，
    //参照cn.com.duiba.kjy.liveweb.vo.websocket.WsLiveRedHelpVo

    ENTER_LIVE_SUCCESS(109901, "进入直播间成功"),
    ENTER_LIVE_ERROR(109902, "进入直播间失败"),

    //10代表客集集，01代表红包业务，01-是具体的推送
    //80代表前端使用
    KJY_RED_FINISHED(100102, "推送红包被领取完了"),
    KJY_RED_HELP(100103, "推送红包助力"),
    KJY_RED_REFRESH(100107, "助播新增或发布了红包"),
    KJY_RED_LIST_AFTER_USER_SUBSCRIBE(100108, "用户订阅成功时推送红包数组"),

    //答题红包
    KJY_QUESTION_RED_REFRESH(100109, "助播上架了答题红包"),
    KJY_QUESTION_RED_PUBLISH(100110, "助播发布了答题红包"),
    KJY_QUESTION_RED_FINISHED(100111, "推送答题红包被领取完了"),

    //猜数红包
    KJY_GUESS_RED_START(100112, "助播发布了猜数红包"),
    KJY_GUESS_RED_END(100113, "助播结束了猜数红包/猜数红包被领取完了"),
    KJY_GUESS_RED_HELP(100114, "猜数红包助力推送"),


    //02 互动相关
	KJY_SPOKE(100201,"弹幕"),
    KJY_NEW_VISITOR(100202,"有人来了"),
    KJY_INTIME_DATA(100203,"直播间实时数据"),
    KJY_BANNED(100204,"禁言标志"),
    KJY_SHARE(100205,"分享直播间"),
    KJY_START(100206,"直播开始"),
    KJY_NOTICE(100207,"管理员公告"),
    KJY_APPOINTMENT_SUBSCRIBE(100208,"订阅直播间"),

    KJY_END(100209,"直播结束"),
    KJY_BREAK(100210,"直播断开"),
    KJY_CONTINUE(100211,"直播继续"),
    KJY_SPOKE_LIST(100212,"最近30条弹幕列表"),
    KJY_QUESTION_NEW(100213,"管理员提问列表"),
    KJY_EXPLAIN(100214,"发布直播讲解介绍配置推送"),
    KJY_EXPLAIN_CLOSE(100215,"关闭直播讲解介绍配置推送"),
    KJY_STREAM_CHANGE(100216,"直播流切换"),

    // 03代表权益业务
    KJY_LIVE_REWARD_PRODUCT(100301, "推送权益"),
    KJY_LIVE_WELFARE_DRAW(100302, "推送已领取权益"),
    KJY_LIVE_REWARD_LOTTERY_START(100303, "福利抽奖开始"),
    KJY_LIVE_REWARD_LOTTERY_END(100304, "福利抽奖结束"),
    KJY_LIVE_WATCH_TIME_LOTTERY_CODE(100305, "观看时长满20分钟获得抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_AFTER_USER_SUBSCRIBE(100306, "用户订阅成功时推送正在抽奖的福利"),
    KJY_LIVE_REWARD_LOTTERY_APPOINTMENT(100307,"获得预约直播间的抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_SIGN(100308,"获得签到抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_SUBSCRIBE(100309,"获得订阅抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_INVITATION(100310,"获得邀请抽奖码"),
    KJY_LIVE_REWARD_LOTTERY_SAVE_SHARE_POSTER(100311,"保存分享海报"),
    KJY_LIVE_REWARD_LOTTERY_SUBMIT_SURVEY(100312, "直播问卷提交推送"),
    KJY_LIVE_TREASURE_LOTTERY_CODE(100313, "宝箱获得抽奖码"),



    /**
     * 测一测
     * 04
     */
    KJY_LIVE_CHOICE_QUESTION_PUSH(100401,"测一测推送"),
    KJY_LIVE_CHOICE_CLOSE(100402,"测一测关闭"),

    /**
     * 咨询
     * 05
     */
    KJJ_LIVE_ADVICE_NEW_MSG(100501, "有新消息到达"),
    KJJ_LIVE_ADVICE_READ(100502, "消息已读"),
    KJJ_LIVE_ADVICE_SEND_RESULT(100503, "消息发送结果"),
    KJJ_LIVE_ADVICE_ADMIN_NEW_MSG(100504, "管理员有新消息到达"),
    KJJ_LIVE_ADVICE_ADMIN_READ(100505, "管理员消息已读"),
    KJJ_LIVE_ADVICE_ADMIN_SEND_RESULT(100506, "管理员消息发送结果"),


    /**
     * 主播端推送相关
     * 06
     */
    KJY_LIVE_PUSH_ON(100601, "上架推送"),
    KJY_LIVE_PUSH_OFF(100602, "下架推送"),
    KJY_LIVE_PUSH_SUBSCRIBE(100603, "订阅成功后，推送上架中推送"),
    KJY_LIVE_PASTER_PUSH_ON(100604, "开启资料贴片推送"),
    KJY_LIVE_PASTER_PUSH_OFF(100605, "关闭资料贴片推送"),


    /**
     * 幸运任务完成推送
     */
    KJY_LIVE_LUCK_TASK_FINISH(100701, "幸运任务完成推送"),

    /**
     * 新版答题中奖
     */
    KJY_QUES_REWARD_ON(100801, "上架答题配置"),
    KJY_QUES_REWARD_PUBLISH(100802, "发布答题配置"),
    KJY_QUES_REWARD_END(100803, "结束答题配置"),

    /**
     * 直播宝箱
     */
    KJY_LIVE_TREASURE_OPEN_PUSH(100901, "直播宝箱满足开启条件推送"),

    /**
     * 猜题红包降级 发放抽奖码 推送
     */
    KJY_GUESS_RED_SEND_CODE_OPEN_PUSH(101001, "猜题红包降级 发放抽奖码 推送"),



    /*
     * 注意：80开头，被前端占用，后端不能使用
     */
    ;
    private final int type;
    private final String desc;

    WsMsgTypeEnum(int type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, WsMsgTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WsMsgTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.type, typeEnum);
        }
    }

    public static WsMsgTypeEnum getByType(int type) {
        return ENUM_MAP.get(type);
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
