package cn.com.duiba.live.ws.register.api.dto.message;

import cn.com.duiba.live.ws.register.api.enums.WsMsgTypeEnum;
import com.alibaba.fastjson.JSON;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/1/12 7:32 下午
 */
public class WsResultBuilder {

    /**
     * 使用自定义成功码的成功数据对象构建
     *
     * @param msgType 成功码
     * @param data 数据
     * @return Result
     */
    public static <T extends MessageBody> WsResultDto success(WsMsgTypeEnum msgType, T data) {
        if (Objects.isNull(data)){
            return new WsResultDto(msgType.getType(),"");
        }
        return new WsResultDto(msgType.getType(), JSON.toJSONString(Collections.singletonList(data)));
    }


    public static WsResultDto success(WsMsgTypeEnum msgType) {
        return new WsResultDto(msgType.getType(),"");
    }


    /**
     * 使用自定义成功码的成功数据对象构建
     *
     * @param msgType 成功码
     * @param data 数据
     * @return Result
     */
    public static <T extends MessageBody> WsResultDto successList(WsMsgTypeEnum msgType, List<T> data) {
        if (Objects.isNull(data)){
            return new WsResultDto(msgType.getType(),"");
        }
        return new WsResultDto(msgType.getType(), JSON.toJSONString(data));
    }
}
