package cn.com.duiba.live.ws.register.api.remoteservice.userconnect;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.ws.register.api.dto.user.WsUserDto;

import java.util.List;

/**
 * @author dugq
 * @date 2021/1/9 8:05 下午
 */
@AdvancedFeignClient
public interface RemoteUserConnectService {

    /**
     * 创建ws连接
     */
    boolean connect(WsUserDto wsUserDto);

    /**
     * 断开 ws连接
     */
    boolean disconnect(WsUserDto wsUserDto);

    void batchDisconnect(List<WsUserDto> dtoList);

    /**
     * 获取某台机器上的所有用户列表
     */
    List<Long> getUserIdsByServerIp(String serverIp);

    /**
     * 获取在线用户ids
     */
    List<Long> getOnlineUserIds(List<Long> liveUserIds);
}
