package cn.com.duiba.local.ext.api.event;

import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;

/**
 * 主容器刷新事件。会在主容器所有bean初始化完成之后，且在主容器发出ContextRefreshedEvent之前发出。由于子容器的ContextRefreshedEvent也
 * 会传给主容器，导致事件会被处理多次，故添加本事件，只会由主容器处理，且只处理一次，在主容器发布ContextRefreshedEvent
 * 之前发布，可以在接收到此事件后做一些初始化动作
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
public class MainContextRefreshedEvent extends ApplicationContextEvent {
    public MainContextRefreshedEvent(ApplicationContext source) {
        super(source);
    }
}