package cn.com.duiba.local.ext.api.sentinel;

import cn.com.duiba.local.ext.api.exception.BizException;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 注解在Exception的子类上，被注解的异常不会被触发Sentinel的熔断
 * <br>
 * e.g. {@link BizException}
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface SentinelDisabled {
}
