package cn.com.duiba.local.autoconfigure.web.reactive;

import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerResponse;

import static org.springframework.web.reactive.function.BodyInserters.fromValue;

/**
 * WebFlux熔断处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Configuration
@AutoConfigureAfter(WebFluxAutoConfiguration.class)
@ConditionalOnBean(WebFluxAutoConfiguration.class)
public class WebFluxBlockAutoConfiguration {
    @Bean
    public BlockRequestHandler blockRequestHandler() {
        return (exchange, t) -> ServerResponse.status(429).contentType(MediaType.APPLICATION_JSON)
                .body(fromValue(JsonResult.fail(BaseError.API_LIMIT.getCode(), "接口调用超过限制")));
    }
}