/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.web.servlet;

import cn.com.duiba.local.autoconfigure.web.servlet.WebMvcExceptionHandler;
import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.fastjson.JSON;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
public class WebMvcExceptionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebMvcExceptionAutoConfiguration.class);

    @Bean
    public WebMvcExceptionHandler webMvcExceptionHandler() {
        log.info("1");
        return new WebMvcExceptionHandler();
    }

    @Bean
    public BlockExceptionHandler blockExceptionHandler() {
        log.info("1");
        return (request, response, e) -> {
            response.setContentType("application/json");
            response.setStatus(429);
            response.getWriter().write(JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_LIMIT.getCode(), (String)BaseError.API_LIMIT.getMsg())));
        };
    }
}

