package cn.com.duiba.local.autoconfigure.web.servlet;

import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.ContentType;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.servlet.Servlet;
import java.nio.charset.StandardCharsets;

/**
 * WebMvc异常处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Slf4j
@Configuration
@AutoConfigureAfter(WebMvcAutoConfiguration.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass({Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
public class WebMvcExceptionAutoConfiguration {
    @Bean
    public WebMvcExceptionHandler webMvcExceptionHandler() {
        return new WebMvcExceptionHandler();
    }

    @Bean
    public BlockExceptionHandler blockExceptionHandler() {
        return (request, response, e) -> {
            response.setContentType(ContentType.build(ContentType.JSON, StandardCharsets.UTF_8));
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            String msg;
            if (e instanceof DegradeException) {
                msg = JSON.toJSONString(JsonResult.fail(BaseError.API_DEGRADE.getCode(),
                        BaseError.API_DEGRADE.getMsg()));
            } else {
                msg = JSON.toJSONString(JsonResult.fail(BaseError.API_FLOW.getCode(),
                        BaseError.API_FLOW.getMsg()));
            }
            // response.getWriter().write(msg);
            IoUtil.writeUtf8(response.getOutputStream(), true, msg);
        };
    }
}