package cn.com.duiba.local.autoconfigure.data.redis;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * hessian反序列化
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Slf4j
@RestControllerEndpoint(id = "hessian2Redis")
public class Hessian2RedisDeserializeMvcEndpoint {
    private final RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    @PostMapping("/deserialize")
    public String invoke(@RequestBody byte[] data) {
        JSONObject redisValueJson = new JSONObject();
        try {
            Object value = valueRedisSerializer.deserialize(data);
            redisValueJson.put("redisValue", value);
            redisValueJson.put("deserializeSuccess", true);
        } catch (Exception e) {
            log.error("Hessian2Redis反序列化异常", e);
            redisValueJson.put("message", e.getMessage());
            redisValueJson.put("deserializeSuccess", false);
        }
        return redisValueJson.toJSONString();
    }
}