/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.data.redis;

import cn.com.duiba.local.autoconfigure.data.redis.Hessian2SerializationRedisSerializer;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestControllerEndpoint(id="hessian2Redis")
public class Hessian2RedisDeserializeMvcEndpoint {
    private static final Logger log = LoggerFactory.getLogger(Hessian2RedisDeserializeMvcEndpoint.class);
    private final RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    @PostMapping(value={"/deserialize"})
    public String invoke(@RequestBody byte[] data) {
        JSONObject redisValueJson = new JSONObject();
        try {
            Object value = this.valueRedisSerializer.deserialize(data);
            redisValueJson.put("redisValue", value);
            redisValueJson.put("deserializeSuccess", (Object)true);
        }
        catch (Exception e) {
            log.error("Hessian2Redis\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
            redisValueJson.put("message", (Object)e.getMessage());
            redisValueJson.put("deserializeSuccess", (Object)false);
        }
        return redisValueJson.toJSONString();
    }
}

