/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.listener;

import cn.com.duiba.local.autoconfigure.DuibaBootVersion;
import java.io.PrintStream;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;

class DuibaBootBanner {
    private static final String BANNER = "          _         _\n  .      | |      _| |           __ _ _\n /\\\\   __| |_   _(_) |,__  _  _  \\ \\ \\ \\\n( ( ) / _` | ' | | |  _  \\/ _` |  \\ \\ \\ \\\n \\\\/ ( (_| | |_| | | |_) | (_| |   ) ) ) )\n  '   \\__,_|\\____|_|.____/\\_,|_\\  / / / /\n ================================/_/_/_/";
    private static final String DUIBA_BOOT = " :: Duiba Boot :: ";
    private static final String SPRING_BOOT = " :: Spring Boot :: ";
    private static final int STRAP_LINE_SIZE = 42;

    DuibaBootBanner() {
    }

    public void printBanner(PrintStream printStream) {
        printStream.println(BANNER);
        String version = DuibaBootVersion.getVersion();
        version = version == null ? "" : " (v" + version + ")";
        StringBuilder padding = new StringBuilder();
        while (padding.length() < 42 - (version.length() + DUIBA_BOOT.length())) {
            padding.append(" ");
        }
        printStream.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, DUIBA_BOOT, AnsiColor.DEFAULT, padding.toString(), AnsiStyle.FAINT, version}));
        version = SpringBootVersion.getVersion();
        version = version == null ? "" : " (v" + version + ")";
        padding = new StringBuilder();
        while (padding.length() < 42 - (version.length() + SPRING_BOOT.length())) {
            padding.append(" ");
        }
        printStream.println(AnsiOutput.toString((Object[])new Object[]{AnsiColor.GREEN, SPRING_BOOT, AnsiColor.DEFAULT, padding.toString(), AnsiStyle.FAINT, version}));
        String bannerExtraInfo = System.getProperty("banner.extra.info");
        if (bannerExtraInfo != null) {
            printStream.println(bannerExtraInfo);
        }
        printStream.println();
    }
}

