/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.web.servlet;

import cn.com.duiba.local.autoconfigure.web.servlet.WebMvcExceptionHandler;
import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.ContentType;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.fastjson.JSON;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
public class WebMvcExceptionAutoConfiguration {
    @Bean
    public WebMvcExceptionHandler webMvcExceptionHandler() {
        return new WebMvcExceptionHandler();
    }

    @Bean
    public BlockExceptionHandler blockExceptionHandler() {
        return (request, response, e) -> {
            response.setContentType(ContentType.build((ContentType)ContentType.JSON, (Charset)StandardCharsets.UTF_8));
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            String msg = e instanceof DegradeException ? JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_DEGRADE.getCode(), (String)BaseError.API_DEGRADE.getMsg())) : JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_FLOW.getCode(), (String)BaseError.API_FLOW.getMsg()));
            IoUtil.writeUtf8((OutputStream)response.getOutputStream(), (boolean)true, (Object[])new Object[]{msg});
        };
    }
}

