package cn.com.duiba.local.autoconfigure.init.server;

import cn.com.duiba.local.ext.api.sentinel.SentinelDisabled;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassUtil;
import com.alibaba.csp.sentinel.Tracer;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.bind.MethodArgumentNotValidException;

import javax.annotation.PostConstruct;
import java.net.BindException;
import java.util.List;
import java.util.Set;

/**
 * 服务启动初始化处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Configuration(proxyBeanMethods = false)
@AutoConfigureOrder(Ordered.HIGHEST_PRECEDENCE)
public class InitServerAutoConfiguration {
    private static final String DUIBA_PACKAGE_NAME = "cn.com.duiba";

    @PostConstruct
    public void init() {
        setExceptionsToIgnore();
    }

    @SuppressWarnings("unchecked")
    private void setExceptionsToIgnore() {
        List<Class<? extends Throwable>> ignoreClassesList = ListUtil.toList(MethodArgumentNotValidException.class,
                BindException.class);
        Set<Class<?>> classes = ClassUtil.scanPackageBySuper(DUIBA_PACKAGE_NAME, Throwable.class);
        for (Class<?> aClass : classes) {
            if (aClass.isAnnotationPresent(SentinelDisabled.class)) {
                ignoreClassesList.add((Class<? extends Throwable>) aClass);
            }
        }
        Class<? extends Throwable>[] ignoreClasses = new Class[ignoreClassesList.size()];
        Tracer.setExceptionsToIgnore(ignoreClassesList.toArray(ignoreClasses));
    }
}