package cn.com.duiba.local.autoconfigure.mq.rocket;

import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;

/**
 * Rocket MQ 自动装配
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Configuration
@ConditionalOnClass(DefaultMQProducer.class)
@EnableConfigurationProperties(RocketMqProperties.class)
public class RocketMqAutoConfiguration {
    @Resource
    private RocketMqProperties rocketMqProperties;

    @ConditionalOnProperty(prefix = RocketMqProperties.ROCKET_PREFIX, name = "producer.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "rocketMqProducer")
    @Bean(name = "rocketMqProducer", destroyMethod = "shutdown")
    public DefaultMQProducer rocketMqProducer() throws MQClientException {
        DefaultMQProducer producer = new DefaultMQProducer(rocketMqProperties.getProducer().getGroup());
        producer.setNamesrvAddr(rocketMqProperties.getNameSrvAddress());
        producer.setSendMsgTimeout(rocketMqProperties.getProducer().getSendMsgTimeoutMillis());
        producer.start();
        return producer;
    }

    @ConditionalOnProperty(prefix = RocketMqProperties.ROCKET_PREFIX, name = "consumer.enable", havingValue = "true")
    @ConditionalOnMissingBean(name = "rocketMqConsumer")
    @Bean(name = "rocketMqConsumer", destroyMethod = "shutdown")
    public DefaultMQPushConsumer rocketMqConsumer() throws MQClientException {
        RocketMqProperties.Consumer consumerProperties = rocketMqProperties.getConsumer();
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(consumerProperties.getGroup());
        consumer.setNamesrvAddr(rocketMqProperties.getNameSrvAddress());
        consumer.setMaxReconsumeTimes(consumerProperties.getMaxReConsumeTimes());
        consumer.setConsumeThreadMin(consumerProperties.getConsumeMinThreadNumber());
        consumer.setConsumeThreadMax(Math.max(consumerProperties.getMaxReConsumeTimes(), 64));
        consumer.setMessageModel(consumerProperties.getMessageModel());
        consumer.setConsumeMessageBatchMaxSize(consumerProperties.getConsumeMessageBatchMaxSize());
        String topics = consumerProperties.getTopics();
        String[] topicArr = topics.split(",");
        for (String topic : topicArr) {
            consumer.subscribe(topic, "*");
        }
        return consumer;
    }
}