package cn.com.duiba.local.autoconfigure.mq.rocket;

import lombok.Getter;
import lombok.Setter;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * TODO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Getter
@Setter
@ConfigurationProperties(prefix = RocketMqProperties.ROCKET_PREFIX)
public class RocketMqProperties {
    public static final String ROCKET_PREFIX = "duiba.rocketmq";

    private String nameSrvAddress;

    private Producer producer;

    private Consumer consumer;

    @Getter
    @Setter
    public static class Producer {
        private Boolean enable = false;

        private String group;

        private Integer sendMsgTimeoutMillis = 400;
    }

    @Getter
    @Setter
    public static class Consumer {
        private Boolean enable = false;

        /**
         * 即ConsumerId
         */
        private String group;

        /**
         * 需要订阅的topic，多个用英文半角逗号隔开
         */
        private String topics;

        private MessageModel messageModel = MessageModel.CLUSTERING;

        /**
         * 消息消费的最大重试次数，默认16
         */
        private Integer maxReConsumeTimes = 16;
        /**
         * 消费线程数量, 不设置时线程池最小大小为20，最大为64。如果你设置了，则最小值是你设的值，最大值是max(你设置的值, 64),一般默认即可
         */
        private Integer consumeMinThreadNumber = 20;

        private Integer consumeMaxThreadNumber = 64;

        /**
         * MessageListener监听器每次接受本地队列的消息是多少条(默认1条，注意这个配置不能控制每次从rocketmq服务器拉取的条数）
         */
        private Integer consumeMessageBatchMaxSize = 1;
    }
}