/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.close;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duiba.local.autoconfigure.core.EarlyClose;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class GraceCloseAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraceCloseAutoConfiguration.class);
    @Value(value="${duiba.grace.close.wait.seconds:6}")
    private int graceCloseWaitSeconds;

    @Bean
    public GracefulCloseLifeCycle gracefulCloseLifeCycle() {
        return new GracefulCloseLifeCycle(this.graceCloseWaitSeconds);
    }

    public static class GracefulCloseLifeCycle
    extends EarlyClose {
        private final int sleepSeconds;

        public GracefulCloseLifeCycle(int sleepSeconds) {
            this.sleepSeconds = sleepSeconds;
        }

        public void stop() {
            if (!log.isInfoEnabled()) {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.getLogger(GraceCloseAutoConfiguration.class).setLevel(Level.INFO);
            }
            log.info("grace closing");
            try {
                TimeUnit.SECONDS.sleep(this.sleepSeconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public int getPhase() {
            return -1;
        }
    }
}

