/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.init.server;

import cn.com.duiba.local.autoconfigure.init.server.MainContextRefreshedEventPublishApplicationRunner;
import cn.com.duiba.local.ext.api.sentinel.SentinelDisabled;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassUtil;
import com.alibaba.csp.sentinel.Tracer;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.MethodArgumentNotValidException;

@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=-2147483648)
public class InitServerAutoConfiguration {
    private static final String DUIBA_PACKAGE_NAME = "cn.com.duiba";

    @PostConstruct
    public void init() {
        this.setExceptionsToIgnore();
    }

    private void setExceptionsToIgnore() {
        ArrayList ignoreClassesList = ListUtil.toList((Object[])new Class[]{MethodArgumentNotValidException.class, BindException.class});
        Set classes = ClassUtil.scanPackageBySuper((String)DUIBA_PACKAGE_NAME, Throwable.class);
        for (Class aClass : classes) {
            if (!aClass.isAnnotationPresent(SentinelDisabled.class)) continue;
            ignoreClassesList.add(aClass);
        }
        Class[] ignoreClasses = new Class[ignoreClassesList.size()];
        Tracer.setExceptionsToIgnore((Class[])ignoreClassesList.toArray(ignoreClasses));
    }

    @Bean
    public ApplicationRunner mainContextRefreshedEventPublishApplicationRunner() {
        return new MainContextRefreshedEventPublishApplicationRunner();
    }
}

