/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.mq.rocket;

import cn.hutool.extra.spring.SpringUtil;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class RocketMqConsumerListener {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConsumerListener.class);
    public static final String ROCKET_MQ_LISTENER_BEAN_NAME = "duibaRocketMqMessageListener";
    private boolean started = false;

    public synchronized void startRun() {
        MessageListener rocketMqMessageListener;
        if (this.started) {
            log.warn("rocketmq consumer have already started, please don't call start again");
            return;
        }
        DefaultMQPushConsumer consumer = (DefaultMQPushConsumer)SpringUtil.getBean((String)"rocketMqConsumer");
        try {
            rocketMqMessageListener = (MessageListener)SpringUtil.getBean((String)ROCKET_MQ_LISTENER_BEAN_NAME, MessageListener.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException("bean id:[duibaRocketMqMessageListener] class:[org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context,\u8bf7\u58f0\u660e\uff0c\u5426\u5219\u4e0d\u4f1a\u542f\u7528rocketmq\u6d88\u8d39\uff01");
        }
        if (rocketMqMessageListener instanceof MessageListenerConcurrently) {
            consumer.registerMessageListener((MessageListenerConcurrently)rocketMqMessageListener);
        } else if (rocketMqMessageListener instanceof MessageListenerOrderly) {
            consumer.registerMessageListener((MessageListenerOrderly)rocketMqMessageListener);
        }
        try {
            consumer.start();
        }
        catch (MQClientException e) {
            throw new RuntimeException(e);
        }
        this.started = true;
    }
}

