/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.data.redis;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class Hessian2SerializationRedisSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(Hessian2SerializationRedisSerializer.class);
    public static final int FLAG_COMPRESSED = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static final int DEFAULT_MAX_SIZE = 0x100000;

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length == 1) {
            throw new SerializationException("Cannot deserialize, bytes.length must be > 1, maybe this key is used by other redis client\uff0cor you use RedisTemplate to incr/decr");
        }
        try {
            byte flags = bytes[0];
            byte[] data = Arrays.copyOfRange(bytes, 1, bytes.length);
            if ((flags & 1) != 0) {
                data = this.decompress(data);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)in);
            return hessian2Input.readObject();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize, maybe this key is used by other redis client", (Throwable)ex);
        }
    }

    public byte[] serialize(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        try {
            int maxSize;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)out);
            hessian2Output.writeObject(object);
            hessian2Output.flush();
            byte[] data = out.toByteArray();
            int flags = 0;
            int compressionThreshold = 1024;
            if (data.length > compressionThreshold) {
                byte[] compressed = this.compress(data);
                if (compressed.length < data.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                    }
                    data = compressed;
                    flags = (byte)(flags | 1);
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + object.getClass().getName() + " from " + data.length + " to " + compressed.length);
                }
            }
            if (data.length > (maxSize = 0x100000)) {
                throw new IllegalArgumentException("Cannot cache data larger than " + maxSize + " byte (you tried to cache a " + data.length + " byte object)");
            }
            out = new ByteArrayOutputStream();
            out.write(flags);
            out.write(data);
            return out.toByteArray();
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize", (Throwable)ex);
        }
    }

    public final byte[] compress(byte[] in) {
        return this.gzipCompress(in);
    }

    /*
     * Exception decompiling
     */
    private byte[] gzipCompress(byte[] in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] decompress(byte[] in) {
        return this.gzipDecompress(in);
    }

    private byte[] gzipDecompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            bos = new ByteArrayOutputStream();
            try (ByteArrayInputStream bis = new ByteArrayInputStream(in);
                 GZIPInputStream gis = new GZIPInputStream(bis);){
                int r;
                byte[] buf = new byte[16384];
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                log.error("Failed to decompress data", (Throwable)e);
                bos = null;
            }
        }
        return bos == null ? null : bos.toByteArray();
    }
}

