/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.data.redis;

import cn.com.duiba.local.autoconfigure.data.redis.Hessian2RedisDeserializeMvcEndpoint;
import cn.com.duiba.local.autoconfigure.data.redis.LettuceConnectionConfiguration;
import com.alibaba.fastjson.support.spring.GenericFastJsonRedisSerializer;
import org.redisson.spring.starter.RedissonAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration.class, RedissonAutoConfiguration.class})
@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@Import(value={LettuceConnectionConfiguration.class})
public class RedisAutoConfiguration {
    @Bean(name={"redisTemplate"})
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setDefaultSerializer((RedisSerializer)new GenericFastJsonRedisSerializer());
        return template;
    }

    @Bean(name={"stringRedisTemplate"})
    @ConditionalOnMissingBean(name={"stringRedisTemplate"})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public Hessian2RedisDeserializeMvcEndpoint hessian2RedisDeserializeMvcEndpoint() {
        return new Hessian2RedisDeserializeMvcEndpoint();
    }
}

