/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.listener;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.com.duiba.local.autoconfigure.listener.DuibaBootBanner;
import cn.com.duiba.local.ext.api.event.ContextClosingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class DuibaBootRunListener
implements SpringApplicationRunListener {
    private static final Logger log = LoggerFactory.getLogger(DuibaBootRunListener.class);
    private static boolean startingFlag = false;
    private final SpringApplication application;

    public DuibaBootRunListener(SpringApplication sa, String[] args) {
        this.application = sa;
    }

    public void starting() {
        if (!startingFlag) {
            startingFlag = true;
            this.application.setBannerMode(Banner.Mode.OFF);
            new DuibaBootBanner().printBanner(System.out);
        }
    }

    public void started(final ConfigurableApplicationContext context) {
        if (!(context instanceof GenericWebApplicationContext) && !(context instanceof ReactiveWebApplicationContext)) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread("ShutDownThread"){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                if (!log.isInfoEnabled()) {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    loggerContext.getLogger(DuibaBootRunListener.class).setLevel(Level.INFO);
                }
                log.info("begin to shutdown server...");
                log.info("clean up spring");
                context.publishEvent((ApplicationEvent)new ContextClosingEvent((ApplicationContext)context));
                context.close();
                long period = System.currentTimeMillis() - start;
                log.info("shutdown server finished successfully\uff0ccost\uff1a{} ms, bye bye...", (Object)period);
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.stop();
            }
        });
    }
}

