/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.mq.rocket;

import cn.com.duiba.local.autoconfigure.mq.rocket.RocketMqConsumerListener;
import cn.com.duiba.local.autoconfigure.mq.rocket.RocketMqProperties;
import cn.com.duiba.local.ext.api.event.MainContextRefreshedEvent;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={DefaultMQProducer.class, DefaultMQPushConsumer.class})
@EnableConfigurationProperties(value={RocketMqProperties.class})
public class RocketMqAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RocketMqAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={DefaultMQPushConsumer.class})
    @ConditionalOnMissingBean(name={"rocketMqConsumer"})
    @ConditionalOnProperty(prefix="duiba.rocketmq", name={"consumer.enable"}, havingValue="true")
    protected static class RocketMqConsumerConfiguration
    extends RocketMqClientConfiguration {
        protected RocketMqConsumerConfiguration() {
        }

        @Bean(name={"rocketMqConsumer"}, destroyMethod="shutdown")
        public DefaultMQPushConsumer rocketMqConsumer() throws MQClientException {
            String[] topicArr;
            RocketMqProperties.Consumer consumerProperties = this.rocketMqProperties.getConsumer();
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(consumerProperties.getGroup());
            consumer.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddress());
            consumer.setMaxReconsumeTimes(consumerProperties.getMaxReConsumeTimes().intValue());
            consumer.setConsumeThreadMin(consumerProperties.getConsumeMinThreadNumber().intValue());
            consumer.setConsumeThreadMax(Math.max(consumerProperties.getMaxReConsumeTimes(), 64));
            consumer.setMessageModel(consumerProperties.getMessageModel());
            consumer.setConsumeMessageBatchMaxSize(consumerProperties.getConsumeMessageBatchMaxSize().intValue());
            String topics = consumerProperties.getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*");
            }
            return consumer;
        }

        @EventListener(value={MainContextRefreshedEvent.class})
        public void initListener() {
            new RocketMqConsumerListener().startRun();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DefaultMQProducer.class})
    @ConditionalOnMissingBean(name={"rocketMqProducer"})
    @ConditionalOnProperty(prefix="duiba.rocketmq", name={"producer.enable"}, havingValue="true")
    protected static class RocketMqProducerConfiguration
    extends RocketMqClientConfiguration {
        protected RocketMqProducerConfiguration() {
        }

        @Bean(name={"rocketMqProducer"}, destroyMethod="shutdown")
        public DefaultMQProducer rocketMqProducer() throws MQClientException {
            DefaultMQProducer producer = new DefaultMQProducer(this.rocketMqProperties.getProducer().getGroup());
            producer.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddress());
            producer.setSendMsgTimeout(this.rocketMqProperties.getProducer().getSendMsgTimeoutMillis().intValue());
            producer.start();
            return producer;
        }
    }

    protected static abstract class RocketMqClientConfiguration {
        @Resource
        protected RocketMqProperties rocketMqProperties;

        protected RocketMqClientConfiguration() {
        }
    }
}

