package cn.com.duiba.mall.center.api.domain.dto.shop;

import cn.com.duiba.mall.center.api.domain.enums.ActivityStatusEnum;
import cn.com.duiba.mall.center.api.domain.enums.MarketTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zyj on 2018/6/25.
 * 营销活动
 */
public class MarketActivityDto implements Serializable{

    private static final long serialVersionUID = -3365344536179712415L;
    /**
     * id
     */
    private Long id;
    /**
     * appId
     */
    private Long appId;
    /**
     * 活动标题
     */
    private String title;
    /**
     *优惠门槛,单位(分)
     */
    private Long discountSill;
    /**
     * 优惠金额,单位(分)
     */
    private Long discountAmount;
    /**
     *活动类型:1:满减送,2:满包邮
     */
    private MarketTypeEnum marketType;
    /**
     * 活动状态:1:开启,2:关闭
     * */
    private ActivityStatusEnum activityStatus;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getDiscountSill() {
        return discountSill;
    }

    public void setDiscountSill(Long discountSill) {
        this.discountSill = discountSill;
    }

    public Long getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(Long discountAmount) {
        this.discountAmount = discountAmount;
    }

    public MarketTypeEnum getMarketType() {
        return marketType;
    }

    public void setMarketType(MarketTypeEnum marketType) {
        this.marketType = marketType;
    }

    public ActivityStatusEnum getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(ActivityStatusEnum activityStatus) {
        this.activityStatus = activityStatus;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}
