/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mall.center.api.domain.enums;

import cn.com.duiba.mall.center.api.domain.MallCenterException;
import cn.com.duiba.mall.center.api.domain.enums.ErrorCode;
import java.util.HashMap;
import java.util.Map;

public enum MarketTypeEnum {
    FULL_SUBTRACTION(1, "\u5a4a\u2033\u567a\u95ab\ufffd"),
    FULL_MAIL(2, "\u5a4a\u2033\u5bd8\u95ad\ufffd");

    private static final Map<Integer, MarketTypeEnum> ENUM_MAP;
    private int value;
    private String desc;

    public static MarketTypeEnum getByCode(Integer code) {
        MarketTypeEnum marketTypeEnum = ENUM_MAP.get(code);
        if (marketTypeEnum == null) {
            throw new MallCenterException(ErrorCode.MC000004);
        }
        return marketTypeEnum;
    }

    private MarketTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<Integer, MarketTypeEnum>();
        for (MarketTypeEnum marketTypeEnum : MarketTypeEnum.values()) {
            ENUM_MAP.put(marketTypeEnum.getValue(), marketTypeEnum);
        }
    }
}

