package cn.com.duiba.mall.center.api.domain.dto.discount;

import java.io.Serializable;
import java.util.Objects;

/**
 * 优惠券组合
 *
 * @author fja
 */
public class DiscountCombination implements Serializable {
    private DiscountTicketDto main;

    private DiscountTicketDto sub;

    public DiscountCombination() {
    }

    public DiscountCombination(DiscountTicketDto main) {
        this.main = main;
    }

    public DiscountCombination(DiscountTicketDto main, DiscountTicketDto sub) {
        this.main = main;
        this.sub = sub;
    }

    public Long totalAmount() {
        if(Objects.nonNull(main) && Objects.nonNull(sub)) {
            return main.getDiscountAmount() + sub.getDiscountAmount();
        } else if(Objects.nonNull(main)) {
            return main.getDiscountAmount();
        } else {
            return sub.getDiscountAmount();
        }
    }

    public DiscountTicketDto getMain() {
        return main;
    }

    public void setMain(DiscountTicketDto main) {
        this.main = main;
    }

    public DiscountTicketDto getSub() {
        return sub;
    }

    public void setSub(DiscountTicketDto sub) {
        this.sub = sub;
    }
}
