package cn.com.duiba.mall.center.api.domain.dto.discount;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户优惠券表
 */
public class ConsumerDiscountDto implements Serializable {

    private static final long serialVersionUID = 4020229237617814553L;
    /**
     * 主键
     */
    private Long id;

    /**
     * appid
     */
    private Long appId;

    /**
     * 开发者用户id
     */
    private String partnerUserId;

    /**
     * 兑吧用户id
     */
    private Long consumerId;

    /**
     * tb_discount表主键
     */
    private Long discountId;

    /**
     * 使用状态：1: 未使用, 2:已冻结，3：已使用
     */
    private Integer useStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 扩展
     */
    private String extraJson;

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    /**
     * 优惠券名称
     */
    private String discountTitle;

    /**
     * 0: 不可叠加，1：可叠加
     */
    private Integer combineType;

    /**
     * 使用范围 1: 全品类，2：全品类（自有），3：全品类（兑吧），4：单品券，5：分组类
     */
    private Integer discountScope;

    /**
     * 满减金额（单位分）、满折百分比
     */
    private Long discountAmount;

    /**
     * 使用门槛 （单位分）
     */
    private Long discountThreshold;

    /**
     * 有效期开始日期
     */
    private Date effectiveStartDate;


    /**
     * 有效期结束日期
     */
    private Date effectiveEndDate;



    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setDiscountId(Long discountId) {
        this.discountId = discountId;
    }

    public Long getDiscountId() {
        return discountId;
    }

    public void setUseStatus(Integer useStatus) {
        this.useStatus = useStatus;
    }

    public Integer getUseStatus() {
        return useStatus;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public String getDiscountTitle() {
        return discountTitle;
    }

    public void setDiscountTitle(String discountTitle) {
        this.discountTitle = discountTitle;
    }

    public Integer getCombineType() {
        return combineType;
    }

    public void setCombineType(Integer combineType) {
        this.combineType = combineType;
    }

    public Integer getDiscountScope() {
        return discountScope;
    }

    public void setDiscountScope(Integer discountScope) {
        this.discountScope = discountScope;
    }

    public Long getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(Long discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Long getDiscountThreshold() {
        return discountThreshold;
    }

    public void setDiscountThreshold(Long discountThreshold) {
        this.discountThreshold = discountThreshold;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }
}

