package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.discount.*;
import cn.com.duiba.mall.center.api.domain.paramquary.discount.DiscountTicketListQueryParam;
import cn.com.duiba.mall.center.api.domain.paramquary.discount.UserAvailableTicketsQueryParam;
import cn.com.duiba.mall.center.api.domain.paramquary.discount.UserGoodsTicketsQueryParam;
import cn.com.duiba.mall.center.api.domain.vo.DiscountTicketVo;

import java.util.List;
import java.util.Set;

/**
 * 商品关联的优惠券
 *
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteDiscountTicketService {


    /**
     * 新建优惠券
     *
     * @param discountTicketDto
     * @return
     */
    Long save(DiscountTicketDto discountTicketDto);

    /**
     * 根据id 批量查询优惠券
     *
     * @param ids 主键
     * @return 优惠券
     */
    List<DiscountTicketDto> listByIds(List<Long> ids);


    /**
     * 根据id查询优惠券
     *
     * @param id
     * @return
     */
    DiscountTicketDetailDto findById(Long id);

    /**
     * 批量查询优惠券
     *
     * @param queryParam 查询条件
     * @return 优惠券
     */
    List<DiscountTicketDto> listByQueryParam(DiscountTicketListQueryParam queryParam);

    /**
     * 用户可用优惠券
     *
     * @param queryParam 查询条件
     * @return
     */
    List<DiscountTicketDto> listUserAvailableTickets(UserAvailableTicketsQueryParam queryParam) throws BizException;

    /**
     * 多个商品，用户可使用优惠券列表
     * 用户优惠券状态为待使用
     * (订单确认页使用此接口)
     *
     * @param queryParam
     * @return
     * @throws BizException
     */
    List<ConsumerDiscountDto> listUserAvailableTickets4AnyGood(UserAvailableTicketsQueryParam queryParam);

    /**
     * 更新库存id
     *
     * @param id
     * @param stockId
     * @return
     */
    int updateStockIdById(Long id, Long stockId);

    /**
     * 更新状态
     *
     * @param id
     * @param status
     * @return
     */
    int updateStatusById(Long id, Integer status);

    /**
     * 删除优惠券
     *
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据id更新
     *
     * @param discountTicketDto
     * @return
     */
    int updateById(DiscountTicketDto discountTicketDto);


    /**
     * 优惠券推送到指定的账户列表
     *
     * @param discountId
     * @param consumerIds
     * @return
     */
    void pushToDesignativeUsers(Long discountId, List<Long> consumerIds) throws BizException;


    /**
     * 根据条件查询优惠券分页列表
     *
     * @param dto
     * @return
     */
    PaginationDto<DiscountListResultDto> queryDiscountByCondition(DiscountListQueryDto dto);


    /**
     * 过滤出有优惠券（单品券和全品券）的商品id
     *
     * @param appId
     * @param consumerId
     * @param parentUserId
     * @param appItemIdList
     * @return
     */
    Set<Long> filterHaveDiscountAppItemIds(Long appId, Long consumerId, String parentUserId, List<Long> appItemIdList);


    /**
     * 计算最优优惠
     *
     * @param appId
     * @param consumerId
     * @param parentUserId
     * @param discountAppItemDtoList
     * @return
     */
    OptimalDiscountDto calculateOptimalSolution(Long appId, Long consumerId, String parentUserId, List<DiscountAppItemDto> discountAppItemDtoList);

    /**
     * 商品相关优惠券
     *
     * @param appItemId     商品id
     * @param appId         appId
     * @param partnerUserId 开发者用户id
     * @return 优惠券列表
     */
    List<DiscountTicketDto> discountTickets4Goods(Long appItemId, Long appId, String partnerUserId) throws BizException;


    /**
     * 用户已领取、待领取列表
     *
     * @param queryParam 查询条件
     * @return 优惠券列表
     */
    UserDiscountTicketWrapper listConsumerCanAcquiredAndAcquiredTickets(UserGoodsTicketsQueryParam queryParam) throws BizException;

    /**
     * 用户自动领取优惠券
     * @param discountIds 优惠券id
     * @return true: 领取成功
     */
    Boolean userAutoAcquireTickets(List<Long> discountIds, Long consumerId);


    /**
     * 用户手动领取优惠券
     * @param discountId 优惠券id
     * @return true: 领取成功
     */
    Boolean userManualAcquireTicket(Long discountId, Long consumerId);

    /**
     *
     * @param queryParam
     * @return
     * @throws BizException
     */
    List<DiscountTicketDto> listUserExchangeAvailableTickets(UserAvailableTicketsQueryParam queryParam) throws BizException;
}
