package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.MarketActivityDto;
import cn.com.duiba.mall.center.api.domain.paramquary.MarketActivityParams;

import java.util.List;

/**
 * Created by zyj on 2018/6/26.
 */
@AdvancedFeignClient
public interface RemoteMarketActivityService {
    /**
     * 新增营销活动
     * @param marketActivityDto
     * @return
     */
    Long insert(MarketActivityDto marketActivityDto);
    /**
     * 修改营销活动
     */
    Integer update(MarketActivityDto marketActivityDto);

    /**
     * 按活动类型和活动状态查询，只提供给开发者后台
     */
    List<MarketActivityDto> selectActivityByType(MarketActivityParams marketActivityParams);

    /**
     * 查询应用的满包邮活动
     * 返回为空表示没有在进行中的包邮活动
     * @param appId
     * @return
     */
    MarketActivityDto getFullMailActivity(Long appId);

    /**
     * 删除
     */
    boolean deleteById(Long id);
    /**
     * 通过id查询
     */
    MarketActivityDto selectById(Long id);
    /**
     * 通过商品ids查询活动
     */
    List<MarketActivityDto> selectActivitysByAppItemIds(List<Long> appItemIds);
    /**
     * 通过活动ids查询活动
     */
    List<MarketActivityDto> selectActivitysByIds(List<Long> ids);
    /**
     * 使失效
     */
    boolean makeInvalidById(Long id);

}
