package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.discount.DiscountGoodsDto;

import java.util.List;

/**
 * 商品关联的优惠券
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteDiscountGoodsService {
    /**
     * 根据商品id找到对应的优惠券id
     *
     * @param appItemId 商品id
     * @return 优惠券id集合
     */
    List<Long> listTicketIdsByAppItemId(Long appItemId);


    /**
     * 批量插入数据
     * @param list
     * @return
     */
    int batchSave(List<DiscountGoodsDto> list);

    /**
     * 根据优惠券id和商品id删除
     * @param discountId
     * @param appItemIds
     * @return
     */
    int deleteByDiscountIdAndAppItemIds(Long discountId,List<Long> appItemIds);


}
