package cn.com.duiba.mall.center.api.domain.enums.seckill;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/01/21 11:30.
 */
public enum SecKillActRunStatusEnum {
    STATUS_INIT(0, "未开始"),
    STATUS_INIT_NO_STOCK(1, "未开始且库存不足"),
    STATUS_ING(10, "进行中"),
    STATUS_ING_NO_STOCK(11, "进行中且库存不足"),
    STATUS_END(20, "已结束"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, SecKillActRunStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(SecKillActRunStatusEnum enumVal: SecKillActRunStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    SecKillActRunStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SecKillActRunStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
