package cn.com.duiba.mall.center.api.domain.dto.discount;

import java.io.Serializable;
import java.util.Objects;

/**
 * 优惠券组合
 *
 * @author fja
 */
public class DiscountCombination implements Serializable {
    /**
     * 最佳优惠券 面值相同时选择顺序的权重值
     */
    private int weight = 0;

    private DiscountTicketDto main;

    private DiscountTicketDto sub;

    public DiscountCombination() {
    }

    public DiscountCombination(DiscountTicketDto main) {
        this.main = main;
    }

    public DiscountCombination(DiscountTicketDto main, DiscountTicketDto sub) {
        this.main = main;
        this.sub = sub;
    }

    /**
     * 组合优惠金额
     *
     * @return 金额
     */
    public Long totalAmount() {
        if (Objects.nonNull(main) && Objects.nonNull(sub)) {
            return main.getDiscountAmount() + sub.getDiscountAmount();
        } else if (Objects.nonNull(main)) {
            return main.getDiscountAmount();
        } else {
            return sub.getDiscountAmount();
        }
    }

    /**
     * 组合门槛值之和
     *
     * @return 门槛之和
     */
    public Long totalThreshold() {
        if (Objects.nonNull(main) && Objects.nonNull(sub)) {
            return main.getDiscountThreshold() + sub.getDiscountThreshold();
        } else if (Objects.nonNull(main)) {
            return main.getDiscountThreshold();
        } else {
            return sub.getDiscountThreshold();
        }
    }

    /**
     * 是否叠加
     *
     * @return true: 叠加
     */
    public boolean isCombine() {
        return Objects.nonNull(main) && Objects.nonNull(sub);
    }

    public DiscountTicketDto getMain() {
        return main;
    }

    public void setMain(DiscountTicketDto main) {
        this.main = main;
    }

    public DiscountTicketDto getSub() {
        return sub;
    }

    public void setSub(DiscountTicketDto sub) {
        this.sub = sub;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}
