package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.discount.DiscountOrdersDto;

import java.util.List;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteDiscountOrderService {

    /**
     * 根据主订单id批量查出相关优惠券的记录
     *
     * @param ids 主订单id
     * @return 记录
     */
    List<DiscountOrdersDto> listRecordByMainOrderIds(List<Long> ids);


    /**
     * 根据子订单id批量查出相关优惠券的记录
     *
     * @param ids 子订单id
     * @return 记录
     */
    List<DiscountOrdersDto> listRecordBySubOrderIds(List<Long> ids);


    /**
     * 根据用户优惠券记录id批量查出相关优惠券的记录
     *
     * @param consumerDiscountId 用户优惠券记录id
     * @return 记录
     */
    List<DiscountOrdersDto> listRecordByMainOrderIdAndConsumerDiscountId(Long mainOrderId, Long consumerDiscountId);

    /**
     * 将优惠券订单记录更新为部分退款
     *
     * @param ids        优惠券订单表id
     * @param postSaleId 售后单id
     * @return true 更新成功
     */
    boolean batchMarkAsPartRefunded(List<Long> ids, Long postSaleId);


    /**
     * 将优惠券订单记录更新为全额退款
     *
     * @param ids        优惠券订单表id
     * @param postSaleId 售后单id
     * @return true 更新成功
     */
    boolean batchMarkAsFullRefunded(List<Long> ids, Long postSaleId);
}
