package cn.com.duiba.mall.center.api.domain.enums;

import cn.com.duiba.mall.center.api.domain.MallCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author zyj
 * @date 2018/6/25
 */
public enum MarketTypeEnum {
    /**
     * 营销活动类型
     * auditStatus
     */
    FULL_SUBTRACTION(1,"满减送"),
    FULL_MAIL(2,"满包邮");

    private static final Map<Integer, MarketTypeEnum> ENUM_MAP = new HashMap<>();
    static{
        for(MarketTypeEnum marketTypeEnum : values()){
            ENUM_MAP.put(marketTypeEnum.getValue(), marketTypeEnum);
        }
    }

    public static MarketTypeEnum getByCode(Integer code){
        MarketTypeEnum marketTypeEnum = ENUM_MAP.get(code);
        if(marketTypeEnum == null){
            throw new MallCenterException(ErrorCode.MC000004);
        }
        return marketTypeEnum;
    }

    private int    value;
    private String desc;

    MarketTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
