package cn.com.duiba.mall.center.api.domain.enums;

import cn.com.duiba.mall.center.api.domain.MallCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author chengsiyi
 * @date 2018/6/27 11:42
 */
public enum SelectedStatusEnum {
    /**
     * 购物车商品选中状态
     * selected
     */
    SELECTED(1,"选中"),
    UNSELECTED(0,"未选中");
    private static final Map<Integer, SelectedStatusEnum> ENUM_MAP = new HashMap<>();
    static{
        for(SelectedStatusEnum activityStatusEnum : values()){
            ENUM_MAP.put(activityStatusEnum.getValue(), activityStatusEnum);
        }
    }

    public static SelectedStatusEnum getByCode(Integer code){
        SelectedStatusEnum activityStatusEnum = ENUM_MAP.get(code);
        if(activityStatusEnum == null){
            throw new MallCenterException(ErrorCode.MC000004);
        }
        return activityStatusEnum;
    }

    private int    value;
    private String desc;

    SelectedStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
