package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:04 上午
 * 优惠券上下架状态
 */
public enum DiscountStatus {

    CLOSE(0,"下架"),
    OPEN(1,"上架"),
    INVALID(3,"失效")
    ;

    private int code;
    private String desc;

    DiscountStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountStatus getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountStatus[] values = DiscountStatus.values();
        for(DiscountStatus status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
