package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.AppItemActivityRelationDto;
import cn.com.duiba.mall.center.api.domain.dto.shop.MarketActivityDto;

import java.util.List;

/**
 *
 * @author zyj
 * @date 2018/6/26
 */
@AdvancedFeignClient
public interface RemoteAppItemActivityRelationService {
    /**
     * 批量插入
     * @param appItemActivityRelationDtos
     * @return
     */
    @Deprecated
    int    addRelations(List<AppItemActivityRelationDto> appItemActivityRelationDtos);
    /**
     * 批量删除
     * @deprecated 无调用，计划废弃
     */
    @Deprecated
    int deleteRelations(List<AppItemActivityRelationDto> appItemActivityRelationDtos);
    /**
     * 根据营销活动id查询
     */
    List<AppItemActivityRelationDto> selectByActivityId(Long activityId);
    /**
     * 根据商品ids查询商品关联关系(不包含已结束的活动)
     */
    List<AppItemActivityRelationDto> seleteByItemIds(List<Long> itemIds);
    /**
     * 移除一个商品
     */
    @Deprecated
    boolean deleteRelation(AppItemActivityRelationDto appItemActivityRelationDto);
    /**
     * 根据商品id查询
     * @deprecated 无调用，计划废弃
     */
    @Deprecated
    AppItemActivityRelationDto selectByItemId(Long itemId);
    /**
     * 删除对应活动下面的所有商品
     */
    @Deprecated
    int deleteRelationByActivityId(Long activityId);

    /**
     * 保存活动 ，同时更新营销活动商品关联表
     */
    void updateActivityIdAndRelations(MarketActivityDto marketActivityDto,List<Long> itemIds);

    /**
     * 根据活动id和商品id查询关联商品
     * @param activityIds
     * @param appItemIds
     * @return
     */
    List<AppItemActivityRelationDto> selectRelationItemList(List<Long> activityIds, List<Long> appItemIds);


    
}
