package cn.com.duiba.mall.center.api.remoteservice.groupbuy;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyActConfDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyDetailDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyOrderDto;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyCreateParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyOrderUpdateParam;

import java.util.List;

/**
 * @author czw
 */
@AdvancedFeignClient
public interface RemoteGroupBuyDetailService {
    /**
     * 参团
     * @param param
     */
    GroupBuyOrderDto joinGroup(GroupBuyCreateParam param)throws BizException;

    /**
     * 发起拼团
     * @param param
     * @return 团id
     */
    GroupBuyOrderDto createGroup(GroupBuyCreateParam param)throws BizException;
    /**
     * 更新团订单
     * @param param
     */
    void updateOrderId(Long groupOrderId,Long orderId);

    /**
     * 支付回调后的更新
     *
     * @param groupOrderId
     * @return
     */
    GroupBuyOrderDto doPaySuccess(Long groupOrderId,Long consumerId,Long groupId)throws BizException;

    /**
     * 拼团成功的处理
     * @param groupId
     * @return
     */
    GroupBuyDetailDto doGroupSuccess(Long groupId) throws BizException;
    /**
     * 拼团订单未支付的处理
     * @param groupOrderId 拼团订单号
     * @return
     */
    void doAfterPayCancel(Long groupOrderId)throws BizException;

    /**
     * 查询已到关团时间处于拼团中的团
     * @return
     */
    List<GroupBuyDetailDto> selectCloseGroupList();

    List<GroupBuyDetailDto> selectGroupListByIds(List<Long> ids);
    /**
     * 关团处理
     * @param groupId
     * @return
     */
    void doGroupClose(Long groupId)throws BizException;

    /**
     *
     * @param groupId
     * @return
     */
    GroupBuyDetailDto selectById(Long groupId);

    /**
     * 查询团长发起拼团详情信息（拼团中）
     * @param groupConsumerId
     * @param actId
     * @return
     */
    GroupBuyDetailDto selectByGroupConsumerIdAndActId(Long groupConsumerId, Long actId);
}
