package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/22 11:33 上午
 * 核销状态
 */
public enum DiscountExchangeStatus {

    NOT_EXCHANGE(0,"未核销"),
    ALREADY_EXCHANGE(1,"已核销");

    private int code;
    private String desc;

    DiscountExchangeStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountExchangeStatus getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountExchangeStatus[] values = DiscountExchangeStatus.values();
        for(DiscountExchangeStatus status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
