package cn.com.duiba.mall.center.api.domain.enums;

import cn.com.duiba.mall.center.api.domain.MallCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sunyan on 2019/11/7.
 */
public enum MsgNotifyQueueTypeEnum {

    /**
     * 亚朵待发货
     */
    YADUO_ERP_SEND("yaduoerpsend","亚朵待发货推送");
    private static final Map<String, MsgNotifyQueueTypeEnum> ENUM_MAP = new HashMap<>();
    static{
        for(MsgNotifyQueueTypeEnum msgNotifyQueueTypeEnum : values()){
            ENUM_MAP.put(msgNotifyQueueTypeEnum.getType(), msgNotifyQueueTypeEnum);
        }
    }

    public static MsgNotifyQueueTypeEnum getByCode(String type){
        MsgNotifyQueueTypeEnum msgNotifyQueueTypeEnum = ENUM_MAP.get(type);
        if(msgNotifyQueueTypeEnum == null){
            throw new MallCenterException(ErrorCode.MC000004);
        }
        return msgNotifyQueueTypeEnum;
    }

    private String type;
    private String desc;

    MsgNotifyQueueTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
