package cn.com.duiba.mall.center.api.domain.enums.seckill;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/01/14 14:12.
 */
public enum SecKillActConfEnableStatusEnum {
    STATUS_ENABLE(0, "有效"),
    STATUS_DISABLE(10, "已失效"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, SecKillActConfEnableStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(SecKillActConfEnableStatusEnum enumVal: SecKillActConfEnableStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    SecKillActConfEnableStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SecKillActConfEnableStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
