package cn.com.duiba.mall.center.api.remoteservice.vipgoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.vipgoods.LimitRecordNumsDto;
import cn.com.duiba.mall.center.api.domain.dto.vipgoods.VipGoodsConsumerLimitRecordDto;
import cn.com.duiba.mall.center.api.domain.paramquary.vipgoods.LimitRecordGroupQuery;
import cn.com.duiba.mall.center.api.domain.paramquary.vipgoods.LimitRecordQuery;

import java.util.List;
import java.util.Map;

/**
 * 用户会员商品限购记录
 *
 * @Author: xuwei
 * @Date: 2019/05/16 15:08
 */
@AdvancedFeignClient
public interface RemoteVipGoodsConsumerLimitRecordService {
    /**
     * 插入
     *
     * @param record
     * @return
     */
    Long insert(VipGoodsConsumerLimitRecordDto record);

    /**
     * 批量插入数据
     * @param records
     * @return
     */
    int batchInsert(List<VipGoodsConsumerLimitRecordDto> records);

    /**
     * 统计指定用户指定商品的限购次数
     *
     * @param query
     * @return
     */
    int countConsumerGoodsLimit(LimitRecordQuery query);

    /**
     * 根据日期分组统计用户指定商品限购次数
     *
     * @param query
     * @return
     */
    Map<String, Integer> countConsumerGoodsLimitGroupDay(LimitRecordQuery query);

    /**
     * 批量统计 不同vip商品限制 下 兑换数量
     * @param query
     * @return
     */
    List<LimitRecordNumsDto> countGroupByVipGoodsIds(LimitRecordGroupQuery query);


    /**
     * 批量查询记录
     * @param query
     * @return
     */
    List<VipGoodsConsumerLimitRecordDto> findListByConditions(LimitRecordGroupQuery query);



}